const videoContainer = document.querySelector('.video-container');
const video = document.querySelector('.video-container video');
const controlsContainer = document.querySelector('.video-container .controls-container');
const enableSoundButton = document.getElementById("enableSound");

const playPauseButton = document.querySelector('.video-container .controls button.play-pause');
const rewindButton = document.querySelector('.video-container .controls button.rewind');
const fastForwardButton = document.querySelector('.video-container .controls button.fast-forward');
const volumeButton = document.querySelector('.video-container .controls button.volume');
const fullScreenButton = document.querySelector('.video-container .controls button.full-screen');
const playButton = playPauseButton.querySelector('.playing');
const pauseButton = playPauseButton.querySelector('.paused');
const fullVolumeButton = volumeButton.querySelector('.full-volume');
const mutedButton = volumeButton.querySelector('.muted');
const maximizeButton = fullScreenButton.querySelector('.maximize');
const minimizeButton = fullScreenButton.querySelector('.minimize');

const progressBar = document.querySelector('.video-container .progress-controls .progress-bar');
const watchedBar = document.querySelector('.video-container .progress-controls .progress-bar .watched-bar');
const timeLeft = document.querySelector('.video-container .progress-controls .time-remaining');

let controlsTimeout;

// Ocultar controles y botón de sonido al inicio
controlsContainer.style.opacity = '0';
enableSoundButton.style.display = 'none';

// Cuando el video se cargue
video.addEventListener('loadeddata', () => {
    video.play();
    playButton.style.display = 'none';
    pauseButton.style.display = 'block';
    
    // Activar controles pero sin mostrarlos aún
    controlsContainer.style.opacity = '0';
  // ✅ Muestra los controles cuando el video cargue
    controlsContainer.style.display = 'flex';
    // Mostrar el botón "Activar sonido" si el video está silenciado
    if (video.muted) {
        enableSoundButton.style.display = "block";
    }
});

 // Botón de "Activar sonido"
enableSoundButton.addEventListener("click", () => {
    video.muted = false;
    video.volume = 1.0;
    enableSoundButton.style.display = "none";
});

// Mostrar controles solo cuando el usuario mueva el mouse
const displayControls = () => {
    controlsContainer.style.opacity = '1';
    document.body.style.cursor = 'initial';
    if (controlsTimeout) clearTimeout(controlsTimeout);
    controlsTimeout = setTimeout(() => {
        controlsContainer.style.opacity = '0';
        document.body.style.cursor = 'none';
    }, 3000);
};

// Play/Pause
const playPause = () => {
    if (video.paused) {
        video.play();
        playButton.style.display = 'none';
        pauseButton.style.display = 'block';
    } else {
        video.pause();
        playButton.style.display = 'block';
        pauseButton.style.display = 'none';
    }
};

// Mute/Unmute
const toggleMute = () => {
    video.muted = !video.muted;
    fullVolumeButton.style.display = video.muted ? 'none' : 'block';
    mutedButton.style.display = video.muted ? 'block' : 'none';

    if (video.muted) {
        enableSoundButton.style.display = "block";
    } else {
        enableSoundButton.style.display = "none";
    }
};

const toggleFullScreen = () => {
    if (!document.fullscreenElement) {
        videoContainer.requestFullscreen();
    } else {
        document.exitFullscreen();
    }
};

document.addEventListener('fullscreenchange', () => {
    maximizeButton.style.display = document.fullscreenElement ? 'none' : 'block';
    minimizeButton.style.display = document.fullscreenElement ? 'block' : 'none';
});

// Eventos del teclado
document.addEventListener('keyup', (event) => {
    if (event.code === 'Space') playPause();
    if (event.code === 'KeyM') toggleMute();
    if (event.code === 'KeyF') toggleFullScreen();
    displayControls();
});

document.addEventListener('mousemove', displayControls);   

video.addEventListener('timeupdate', () => {
    watchedBar.style.width = ((video.currentTime / video.duration) * 100) + '%';
    const totalSecondsRemaining = video.duration - video.currentTime;
    const time = new Date(null);
    time.setSeconds(totalSecondsRemaining);
    const hours = totalSecondsRemaining >= 3600 ? (time.getHours().toString()).padStart(2, '0') : '00';
    const minutes = (time.getMinutes().toString()).padStart(2, '0');
    const seconds = (time.getSeconds().toString()).padStart(2, '0');
    timeLeft.textContent = `${hours}:${minutes}:${seconds}`;
});

progressBar.addEventListener('click', (event) => {
    const pos = (event.pageX - progressBar.getBoundingClientRect().left) / progressBar.offsetWidth;
    video.currentTime = pos * video.duration;
});

// Eventos de los botones de control
playPauseButton.addEventListener('click', playPause);
rewindButton.addEventListener('click', () => { video.currentTime -= 10; });
fastForwardButton.addEventListener('click', () => { video.currentTime += 10; });
volumeButton.addEventListener('click', toggleMute);
fullScreenButton.addEventListener('click', toggleFullScreen);
