const carousel = document.querySelector(".carousel");
let slideIndex = 0;

// Función para deslizar el carrusel automáticamente
const autoSlide = () => {
  const slides = document.querySelectorAll(".slider");
  const totalSlides = slides.length;

  // Asegurarse de que haya al menos un slide
  if (totalSlides > 1) {
    // Desplazar el carrusel
    carousel.style.transition = "transform 1s ease-in-out";
    slideIndex = (slideIndex + 1) % totalSlides; // Incrementa el índice y lo vuelve a 0 si se llega al último slide
    const offset = -100 * slideIndex; // Calcula el desplazamiento en porcentaje
    carousel.style.transform = `translateX(${offset}%)`;
  }
};


// Mover el carrusel automáticamente cada 5 segundos
setInterval(autoSlide, 5000);





// Video cards
const videoCards = [...document.querySelectorAll(".video-card")];

videoCards.forEach((item) => {
  item.addEventListener("mouseover", () => {
    let video = item.children[1];
    video.play();
  });
  item.addEventListener("mouseleave", () => {
    let video = item.children[1];
    video.pause();
  });
});

// Movie cards
let cardContainers = [...document.querySelectorAll(".card-container")];
let preBTns = [...document.querySelectorAll(".pre-btn")];
let nxtBtns = [...document.querySelectorAll(".nxt-btn")];

cardContainers.forEach((item, i) => {
  let containerDimensions = item.getBoundingClientRect();
  let containerWidth = containerDimensions.width;

  nxtBtns[i].addEventListener("click", () => {
    item.scrollLeft += containerWidth - 200;
  });

  preBTns[i].addEventListener("click", () => {
    item.scrollLeft -= containerWidth + 200;
  });
});
