<?php
require_once('includes/database.php');
include('includes/header.php');

// Verifica se há uma mensagem de exclusão bem sucedida
if(isset($_GET['excluido']) && $_GET['excluido'] == 'sucesso') {
    echo '<div class="mensagem-sucesso">Produto excluído com sucesso.</div>';
}

$query = "SELECT * FROM produtos";
$result = mysqli_query($conexao, $query);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Products</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<style>
    @media only screen and (max-width: 600px) {
        .container {
            padding: 10px;
        }
        .produto {
            width: 100%;
            margin-bottom: 20px;
        }
        .produto img {
            width: 100%;
            height: auto;
            border-radius: 5px;
        }
        .produto h3 {
            font-size: 1.2em;
        }
        .produto p {
            font-size: 1em;
        }
        .botoes {
            display: flex;
            justify-content: space-between;
        }
        .botoes a {
            flex: 1;
            margin-right: 5px;
            text-align: center;
        }
    }
</style>

<body>

<header>
    <h1>Applications</h1>
</header>
<div class="container">
    <div class="produtos">
        <?php while ($row = mysqli_fetch_assoc($result)) { ?>
            <div class="produto" data-produto="<?php echo $row['id']; ?>">
                <!-- Imagem do produto -->
                <?php 
                if (!empty($row['imagens'])) {
                    $imagens = explode(",", $row['imagens']);
                    echo '<img src="images/' . $imagens[0] . '" alt="' . $imagens[0] . '">';
                } else {
                    echo "No images available";
                }
                ?>
                <!-- Informações do produto -->
                <h3><?php echo $row['nome']; ?></h3>
                <p><?php echo $row['descricao']; ?></p>
                <p>Preço: R$ <?php echo $row['preco']; ?></p>
                <!-- Botões de ação -->
                <div class="botoes">
                    <a href="edit_product.php?id=<?php echo $row['id']; ?>" class="btn-editar">Edit</a>
                    <a href="delete_product.php?id=<?php echo $row['id']; ?>" onclick="return confirm('Are you sure you want to delete this product?')" class="btn-excluir">Delete</a>
                </div>
            </div>
        <?php } ?>
    </div>
</div>

<?php include('includes/footer.php'); ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="js/script.js"></script>

</body>
</html>