<?php
require_once('includes/database.php');

// Verifica se o ID do login foi passado via GET
if (!isset($_GET['id']) || empty($_GET['id'])) {
    // Se não houver ID, redireciona de volta para a página de gerenciamento de logins
    header('Location: manage_logins.php');
    exit;
}

// Obtém o ID do login da URL
$login_id = $_GET['id'];

// Consulta SQL para obter os dados do login com base no ID
$query = "SELECT * FROM logins WHERE id = $login_id";
$result = mysqli_query($conexao, $query);

// Verifica se o login existe no banco de dados
if (mysqli_num_rows($result) != 1) {
    // Se não houver login com o ID especificado, redireciona de volta para a página de gerenciamento de logins
    header('Location: manage_logins.php');
    exit;
}

// Obtém os dados do login
$login = mysqli_fetch_assoc($result);

// Processamento do formulário de edição (se enviado)
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['editar_login'])) {
    // Obtenha os dados do formulário
    $username = $_POST['username'];
    $password = $_POST['password'];
    $email = $_POST['email'];
    $full_name = $_POST['full_name'];

    // Atualiza os dados do login no banco de dados
    $query = "UPDATE logins SET username='$username', password='$password', email='$email', full_name='$full_name' WHERE id = $login_id";
    $resultado = mysqli_query($conexao, $query);

    if ($resultado) {
        // Redireciona de volta para a página de gerenciamento de logins com mensagem de sucesso
        header('Location: manage_logins.php?mensagem=Login editado com sucesso.');
        exit;
    } else {
        // Em caso de erro, exibe uma mensagem de erro
        $error_message = "Erro ao editar o login: " . mysqli_error($conexao);
    }
}
?>

<!-- Formulário de edição do login -->
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Login</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<header>
    <h1>Editar Login</h1>
</header>

<div class="container">
    <?php if (isset($error_message)) { ?>
        <p class="error"><?php echo $error_message; ?></p>
    <?php } ?>

    <form method="post" action="">
        <label for="username">Username:</label>
        <input type="text" name="username" value="<?php echo $login['username']; ?>" required><br>
        <label for="password">Password:</label>
        <input type="password" name="password" value="<?php echo $login['password']; ?>" required><br>
        <label for="email">Email:</label>
        <input type="email" name="email" value="<?php echo $login['email']; ?>" required><br>
        <label for="full_name">Nome Completo:</label>
        <input type="text" name="full_name" value="<?php echo $login['full_name']; ?>" required><br>
        <input type="submit" name="editar_login" value="Salvar">
    </form>
</div>

<?php include('includes/footer.php'); ?>

</body>
</html>
