<?php
require_once('includes/database.php');
include('includes/header.php');

// Verifica se o usuário está autenticado
// Coloque aqui sua lógica de autenticação, como verificar se a sessão está iniciada ou se há um token de autenticação válido

// Função para listar todos os usuários
function listarUsuarios() {
    global $conexao;
    $query = "SELECT * FROM logins";
    $result = mysqli_query($conexao, $query);
    return $result;
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Users</title>
    <style>
        /* Reset de estilos */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        /* Estilo do cabeçalho */
        header {
            background-color: #141414; /* Preto Netflix */
            color: #fff;
            padding: 20px;
            text-align: center;
        }

        header h1 {
            margin: 0;
            font-size: 3em;
            font-weight: bold;
            color: #e50914; /* Vermelho Netflix */
        }

        /* Estilo da tabela */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #fff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
        }

        /* Estilo do cabeçalho da tabela */
        table th {
            background-color: #f2f2f2;
            color: #333;
            padding: 15px;
            text-align: left;
        }

        /* Estilo das linhas alternadas da tabela */
        table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        /* Estilo das células da tabela */
        table td {
            padding: 15px;
            border-bottom: 1px solid #e0e0e0;
        }

        /* Mudança de cor ao passar o mouse sobre as linhas */
        table tr:hover {
            background-color: #e0e0e0;
        }

        /* Estilo dos botões */
        a.btn-editar,
        a.btn-excluir {
            display: inline-block;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-size: 1em;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none; /* Adiciona estilo para remover a sublinhado padrão */
        }

        /* Estilo do botão Editar */
        a.btn-editar {
            background: linear-gradient(to right, #e50914, #ff0000);
            color: #fff;
        }

        /* Estilo do botão Excluir */
        a.btn-excluir {
            background: linear-gradient(to right, #333, #555);
            color: #fff;
        }

        /* Transição suave ao passar o mouse sobre os botões */
        a.btn-editar:hover,
        a.btn-excluir:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
<header>
    <h1>Profile</h1>
</header>

<div class="container">
<div class="form-container">
  
    <table>
        <tr>
            <th>Username</th>
            <th>Actions</th>
        </tr>
        <?php $usuarios = listarUsuarios(); ?>
        <?php while ($row = mysqli_fetch_assoc($usuarios)) { ?>
            <tr>
                <td><?php echo $row['username']; ?></td>
                <td>
                    <a href="edit_user.php?id=<?php echo $row['id']; ?>" class="btn-editar">Edit</a>
                    <a href="delete_user.php?id=<?php echo $row['id']; ?>" onclick="return confirm('Are you sure you want to delete this user?')" class="btn-excluir">Delete</a>
                </td>
            </tr>
        <?php } ?>
    </table>
</div>

</body>
</html>

