<?php
include_once 'banners.php';

// Função para exibir os banners em miniatura
function displayBannersMiniature($banners) {
    foreach ($banners as $banner) {
        // Verifica se a chave 'id' está definida antes de acessá-la
        if (isset($banner['id'])) {
            echo '<div class="banner-miniature">';
            echo '<h4>' . $banner['title'] . '</h4>'; // Adiciona o nome do banner
            echo '<img src="' . $banner['image'] . '" alt="' . $banner['title'] . '" class="banner-image">';
            echo '<div class="banner-buttons">';
            echo '<a href="banner_edit.php?id=' . $banner['id'] . '" class="btn-edit">Edit</a>';
            echo '<a href="banner_delete.php?id=' . $banner['id'] . '" class="btn-delete">Delete</a>';
            echo '</div>';
            echo '</div>';
        } else {
            // Se a chave 'id' não estiver definida, exibe uma mensagem de erro
            echo '<div class="error-message">Error: Banner ID not found.</div>';
        }
    }
}

// Função para salvar os banners em um arquivo
function saveBannersToFile($banners) {
    file_put_contents('banners.php', '<?php $banners = ' . var_export($banners, true) . ';');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Processo de adição do novo banner
    $title = $_POST['title'];
    $url = $_POST['url'];

    // Verifica se o título e a URL foram fornecidos
    if (!empty($title) && !empty($url)) {
        // Adiciona o banner ao array de banners
        $newBanner = [
            'id' => count($banners) + 1,
            'title' => $title,
            'image' => $url
        ];
        $banners[] = $newBanner;

        // Salva o array atualizado de banners no arquivo banners.php
        saveBannersToFile($banners);
        
        // Redireciona de volta para a página para evitar envio duplicado do formulário
        header('Location: banner_add.php');
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Adicionar Banner</title>
    <link rel="stylesheet" href="css/styles.css"> <!-- Seu arquivo CSS -->
</head>
<header>
    <h1>Add Banner</h1>
</header>
<body>
    <?php include_once 'includes/header.php'; ?>

    <div class="container">
        <h2></h2>
        <form action="" method="post">
            <label for="title">Title:</label>
            <input type="text" id="title" name="title" required><br><br>
            <label for="url">Image URL:</label>
            <input type="text" id="url" name="url" required><br><br>
            <input type="submit" value="Add Banner">
        </form>

<div class="container">
        <h3>Existing Banners</h3>
        
            <?php displayBannersMiniature($banners); ?>
        </div>
    </div>

    <?php include_once 'includes/footer.php'; ?>
</body>
</html>
