<?php
include_once 'banners.php';

// Função para salvar os banners em um arquivo
function saveBannersToFile($banners) {
    file_put_contents('banners.php', '<?php $banners = ' . var_export($banners, true) . ';');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];

    // Função para excluir o banner com o ID fornecido
    function deleteBanner($id, &$banners) {
        foreach ($banners as $key => $banner) {
            if ($banner['id'] == $id) {
                unset($banners[$key]);
                return true;
            }
        }
        return false;
    }

    if (deleteBanner($id, $banners)) {
        // Salva o array atualizado de banners no arquivo banners.php
        saveBannersToFile($banners);
        
        header('Location: banner_add.php'); // Redireciona para o painel administrativo após excluir o banner
        exit;
    } else {
        $errorMessage = 'Erro ao excluir banner. Por favor, tente novamente.';
    }
} else {
    // Recupera o ID do banner da URL
    $id = $_GET['id'];
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Banner</title>
    <link rel="stylesheet" href="css/styles.css"> <!-- Seu arquivo CSS -->
</head>
<body>
    <?php include_once 'includes/header.php'; ?>

    <div class="container">
        <h2>Delete Banner</h2>
        <p>Are you sure you want to delete this banner?</p>
        <form action="" method="post">
            <input type="hidden" name="id" value="<?php echo $id; ?>">
            <input type="submit" value="Yes, Delete">
            <a href="banner_add.php">Cancel</a>
        </form>
    </div>

    <?php include_once 'includes/footer.php'; ?>
</body>
</html>
