<?php
require_once('includes/database.php');
include('includes/header.php');

// Verifica se o usuário está autenticado
// Coloque aqui sua lógica de autenticação, como verificar se a sessão está iniciada ou se há um token de autenticação válido

// Função para listar todos os logins
function listarLogins() {
    global $conexao;
    $query = "SELECT * FROM logins";
    $result = mysqli_query($conexao, $query);
    return $result;
}

// Função para adicionar um novo login
function adicionarLogin($username, $password, $email, $full_name) {
    global $conexao;
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $query = "INSERT INTO logins (username, password, email, full_name) VALUES ('$username', '$hashed_password', '$email', '$full_name')";
    $result = mysqli_query($conexao, $query);
    
    if ($result) {
        return true; // Retorna verdadeiro se a inserção for bem-sucedida
    } else {
        // Se houver um erro na consulta, exibe o erro
        echo "Erro ao adicionar login: " . mysqli_error($conexao);
        return false; // Retorna falso se houver erro
    }
}

// Função para editar um login existente
function editarLogin($id, $username, $password, $email, $full_name) {
    global $conexao;
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $query = "UPDATE logins SET username='$username', password='$hashed_password', email='$email', full_name='$full_name' WHERE id=$id";
    $result = mysqli_query($conexao, $query);
    return $result;
}

// Função para excluir um login
function excluirLogin($id) {
    global $conexao;
    $query = "DELETE FROM logins WHERE id=$id";
    $result = mysqli_query($conexao, $query);
    return $result;
}

// Se o formulário de adição for submetido
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['adicionar_login'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $email = $_POST['email'];
    $full_name = $_POST['full_name'];
    adicionarLogin($username, $password, $email, $full_name);
}

// Se o formulário de edição for submetido
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['editar_login'])) {
    $id = $_POST['id'];
    $username = $_POST['username'];
    $password = $_POST['password'];
    $email = $_POST['email'];
    $full_name = $_POST['full_name'];
    editarLogin($id, $username, $password, $email, $full_name);
}

// Se o formulário de exclusão for submetido
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['excluir_login'])) {
    $id = $_POST['id'];
    excluirLogin($id);
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Logins</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>

<header>
    <h1>Profile</h1>
</header>

<div class="container">
<div class="form-container">
    <h2></h2>
    <table>
        <tr>
            <th>Username</th>
            
            
            
        </tr>
        <?php $logins = listarLogins(); ?>
        <?php while ($row = mysqli_fetch_assoc($logins)) { ?>
        <tr>
            <td><?php echo $row['username']; ?></td>
            
            
            
        </tr>
        <?php } ?>
    </table>


    <form method="post" action="">
            <h2>Add New Login</h2><br><br>
        <label for="username">Username:</label>
        <input type="text" name="username" required><br>
        <label for="password">Password:</label>
        <input type="password" name="password" required><br>
        <label for="email">Email:</label>
        <input type="email" name="email" required><br>
        <label for="full_name">Full name:</label>
        <input type="text" name="full_name" required><br>
        <input type="submit" name="adicionar_login" value="Add Login">
    </form>
</div>

<?php include('includes/footer.php'); ?>

</body>
</html>
