document.addEventListener("DOMContentLoaded", function() {
    // Configurações do carrossel
    const intervalo = 3000; // Intervalo de troca de imagens em milissegundos
    const distancia = 300; // Distância de deslocamento para a próxima imagem (em pixels)
    const tempoTransicao = intervalo / 2; // Tempo de transição para suavizar o deslocamento
    let slideInterval;
    let isTransitioning = false; // Controle de estado para verificar se uma transição está em andamento

    // Função para avançar para o próximo slide
    function avancarSlide(carrossel) {
        if (!isTransitioning) {
            isTransitioning = true; // Define o estado como transição em andamento
            const novoDeslocamento = carrossel.scrollLeft + distancia;
            const ultimoSlide = carrossel.scrollWidth - carrossel.clientWidth;
            // Verifica se chegamos ao último slide
            if (novoDeslocamento <= ultimoSlide) {
                // Anima o deslocamento suavemente
                smoothScroll(carrossel, novoDeslocamento, tempoTransicao, function() {
                    isTransitioning = false; // Define o estado como transição concluída
                });
            } else {
                // Se o próximo deslocamento ultrapassar o último slide, volta ao primeiro slide
                smoothScroll(carrossel, 0, tempoTransicao, function() {
                    isTransitioning = false; // Define o estado como transição concluída
                });
            }
        }
    }

    // Função para rolar suavemente para um destino específico
    function smoothScroll(elemento, destino, duracao, callback) {
        const inicio = elemento.scrollLeft;
        const distancia = destino - inicio;
        const startTime = performance.now();

        function scrollStep(timestamp) {
            const tempoPassado = timestamp - startTime;
            const progresso = Math.min(tempoPassado / duracao, 1);
            elemento.scrollLeft = inicio + distancia * progresso;

            if (tempoPassado < duracao) {
                requestAnimationFrame(scrollStep);
            } else {
                if (callback) callback();
            }
        }

        requestAnimationFrame(scrollStep);
    }

    // Iniciar o carrossel para um conjunto de slides
    function iniciarCarrossel(carrossel) {
        // Exibir a primeira imagem do carrossel antes de iniciar o intervalo
        carrossel.scrollTo(0, 0);
        slideInterval = setInterval(function() {
            avancarSlide(carrossel);
        }, intervalo);
    }

    // Parar o carrossel
    function pararCarrossel() {
        clearInterval(slideInterval);
    }

    // Associar eventos de mouse aos produtos para iniciar e parar o carrossel
    const carrosseis = document.querySelectorAll('.carousel');
    carrosseis.forEach(carrossel => {
        carrossel.addEventListener('mouseenter', function() {
            iniciarCarrossel(carrossel);
        });
        carrossel.addEventListener('mouseleave', function() {
            pararCarrossel();
        });
    });
});
