<?php
// Verifique se o parâmetro 'id' foi passado na URL
if (isset($_GET['id']) && !empty($_GET['id'])) {
    // Inclua o arquivo de conexão com o banco de dados e outras dependências
    require_once('includes/database.php');
    include('includes/header.php');

    // Obtém o ID do produto da URL
    $produto_id = $_GET['id'];

    // Consulta para selecionar o produto com o ID fornecido
    $query = "SELECT * FROM produtos WHERE id = $produto_id";
    $result = mysqli_query($conexao, $query);

    // Verifica se o produto foi encontrado no banco de dados
    if (mysqli_num_rows($result) > 0) {
        // Obtém os dados do produto
        $produto = mysqli_fetch_assoc($result);
?>
<!DOCTYPE html>
<html lang="es-MX">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $produto['nome']; ?></title>
    <style>
        /* Estilos para a página do produto */
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            margin: 0;
            padding: 0;
        }

        header {
            background-color: #333;
            color: #fff;
            text-align: center;
            padding: 20px 0;
        }

        .container {
            max-width: 800px;
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .produto-detalhes {
            display: flex;
            flex-wrap: wrap;
        }

        .imagem-produto {
            width: 50%;
            padding-right: 20px;
            box-sizing: border-box;
        }

        .imagem-produto img {
            width: 100%;
            height: auto;
            border-radius: 5px;
            cursor: pointer; /* Adicionando cursor pointer para indicar que a imagem é clicável */
        }

        .informacoes-produto {
            width: 50%;
            padding-left: 20px;
            box-sizing: border-box;
        }

        /* Estilos para as informações do produto */
        .informacoes-produto {
            flex: 1 1 calc(50% - 20px);
            padding: 20px;
            background-color: #f2f2f2;
            border-radius: 5px;
        }

        .informacoes-produto p {
            margin-bottom: 10px;
            font-size: 1em;
            color: #555; /* Alterei a cor do texto para um tom mais escuro */
        }

        .informacoes-produto .descricao p {
            font-size: 1em; /* Tamanho da fonte para a descrição */
            color: #333; /* Cor do texto para a descrição */
        }

        .informacoes-produto .preco p {
            font-size: 1.2em; /* Tamanho da fonte para o preço */
            color: #e50914; /* Cor do texto para o preço */
        }

        .informacoes-produto .titulo {
            font-weight: bold;
            color: #e50914; /* Cor roxa para o texto */
            font-size: 1.2em; /* Tamanho da fonte */
            text-transform: uppercase; /* Transformando o texto em maiúsculas */
            margin-bottom: 8px; /* Espaço extra abaixo do texto */
            border: 2px solid #e50914; /* Contorno roxo */
            padding: 4px 8px; /* Preenchimento interno */
            border-radius: 5px; /* Bordas arredondadas */
        }

        .informacoes-produto .descricao .titulo {
            margin-bottom: 10px; /* Ajuste para a div de descrição */
        }

        .informacoes-produto .preco .titulo {
            margin-bottom: 6px; /* Ajuste para a div de preço */
        }

        .informacoes-produto strong {
            font-weight: bold;
            color: #e50914;
        }

        /* Estilos para o lightbox */
        #lightbox {
            display: none;
            position: fixed;
            z-index: 9999;
            padding: 60px 0;
            text-align: center;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.8);
        }

        #lightbox-img {
            max-width: 90%;
            max-height: 80%;
            margin: auto;
        }

        .close-btn {
            position: absolute;
            top: 20px;
            right: 20px;
            font-size: 30px;
            color: #fff;
            cursor: pointer;
        }
/* Estilos personalizados para a descrição do produto */
.texto-descricao {
    font-size: 0.9em;
    color: #333;
    border: 1px solid #e50914; /* Cor roxa para o contorno */
    padding: 10px;
    border-radius: 5px;
    margin-bottom: 0px;
}

/* Estilos personalizados para o preço do produto */
.texto-preco {
    font-size: 1.8em;
    color: #000;
    padding: 10px;
    border-radius: 5px;
}

    </style>
</head>
<body>
<header>
    <h1><?php echo $produto['nome']; ?></h1>
</header>

<div class="container">
    <div class="produto-detalhes">
        <div class="imagem-produto">
            <?php
            // Verifica se há imagens para exibir
            if (!empty($produto['imagens'])) {
                $imagens = explode(",", $produto['imagens']);
                // Exibe cada imagem do produto com link para abrir o lightbox
                foreach ($imagens as $imagem) {
                    echo '<img src="admin/images/' . $imagem . '" alt="' . $produto['nome'] . '" onclick="openLightbox(\'admin/images/' . $imagem . '\')">';
                }
            } else {
                echo "Nenhuma imagem disponível";
            }
            ?>
        </div>
        <div class="informacoes-produto">
    <div class="descricao">
        <div class="titulo">Detalle apk:</div>
        <div class="texto-descricao"><?php echo $produto['descricao']; ?></div>
    </div>
    <div class="preco">
        <div class="titulo">Precio:</div>
        <div class="texto-preco">USD <?php echo $produto['preco']; ?></div>
    </div>
</div>
<!-- Fim da div .produto-detalhes -->
</div> <!-- Fim da div .container -->

<!-- Lightbox -->
<div id="lightbox" class="lightbox">
    <span class="close-btn" onclick="closeLightbox()">&times;</span>
    <img src="" id="lightbox-img" class="lightbox-img">
</div>

<?php include('includes/footer.php'); ?>

<!-- JavaScript para o lightbox -->
<script>
    function openLightbox(imgSrc) {
        var lightbox = document.getElementById('lightbox');
        var lightboxImg = document.getElementById('lightbox-img');
        lightboxImg.src = imgSrc;
        lightbox.style.display = 'block';
    }

    function closeLightbox() {
        var lightbox = document.getElementById('lightbox');
        lightbox.style.display = 'none';
    }
</script>

</body>
</html>
<?php
    } else {
        // Se o produto não for encontrado, redirecione para uma página de erro ou página inicial
        header("Location: index.php");
        exit();
    }
} else {
    // Se o parâmetro 'id' não for passado na URL, redirecione para uma página de erro ou página inicial
    header("Location: index.php");
    exit();
}
?>
