<?php
include_once 'banners.php';
include_once 'functions.php'; // Inclui o arquivo com a função editBanner()

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $title = $_POST['title'];
    $url = $_POST['url'];

    // Verifica se o banner com o ID fornecido existe
    $bannerIndex = array_search($id, array_column($banners, 'id'));
    if ($bannerIndex !== false) {
        // Atualiza o título e a URL do banner
        $banners[$bannerIndex]['title'] = $title;
        $banners[$bannerIndex]['image'] = $url;

        // Salva o array atualizado de banners no arquivo banners.php
        file_put_contents('banners.php', '<?php $banners = ' . var_export($banners, true) . ';');
        
        header('Location: banner_add.php'); // Redireciona para o painel administrativo após editar o banner
        exit;
    } else {
        $errorMessage = 'Erro: Banner não encontrado.';
    }
} else {
    // Recupera o ID do banner da URL
    $id = $_GET['id'];
    // Recupera os detalhes do banner
    foreach ($banners as $banner) {
        if ($banner['id'] == $id) {
            $title = $banner['title'];
            $url = isset($banner['image']) ? $banner['image'] : ''; // Verifica se a chave 'image' existe antes de atribuir
            break;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Banner</title>
    <link rel="stylesheet" href="css/styles.css"> <!-- Seu arquivo CSS -->
</head>
<body>
    <?php include_once 'includes/header.php'; ?>
<header>Edit Banner</header></header>
    <div class="container">
        <form action="" method="post">
            <input type="hidden" name="id" value="<?php echo $id; ?>">
            <label for="title">Title:</label>
            <input type="text" id="title" name="title" value="<?php echo $title; ?>" required><br><br>
            <label for="url">Image URL:</label>
            <input type="text" id="url" name="url" value="<?php echo $url; ?>" required><br><br>
            <input type="submit" value="Salvar Alterações">
        </form>
    </div>

    <?php include_once 'includes/footer.php'; ?>
</body>
</html>
