<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Produto</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        /* Estilo para a área de descrição */
        .editor-container {
            display: none;
            margin-bottom: 10px;
        }
        .editor-toolbar button {
            margin-right: 5px;
            padding: 5px 10px;
            cursor: pointer;
        }
        textarea {
            width: 100%;
            height: 150px;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
            resize: vertical;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
<header>Edit App</header>

<div class="container">
<div class="form-container">
    <?php
    require_once('includes/database.php');
    include('includes/header.php');

    // Verifica se o ID do produto foi passado via GET
    if (isset($_GET['id'])) {
        $produto_id = $_GET['id'];

        // Consulta o produto no banco de dados
        $query = "SELECT * FROM produtos WHERE id = $produto_id";
        $result = mysqli_query($conexao, $query);

        if (mysqli_num_rows($result) == 1) {
            $row = mysqli_fetch_assoc($result);
            $nome = $row['nome'];
            $preco = $row['preco'];
            $descricao = $row['descricao'];
            $imagens = explode(",", $row['imagens']);
        } else {
            echo "Produto não encontrado.";
            exit();
        }
    } else {
        echo "ID do produto não especificado.";
        exit();
    }

    // Verifica se o formulário foi submetido
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        // Obtém os dados do formulário
        $nome = $_POST['nome'];
        $preco = $_POST['preco'];
        $descricao = $_POST['descricao'];

        // Verifica se o usuário enviou novas imagens
        if (!empty($_FILES['novas_imagens']['name'][0])) {
            // Processa o upload das novas imagens
            $imagens_novas = [];
            foreach ($_FILES['novas_imagens']['tmp_name'] as $key => $tmp_name) {
                $nome_imagem = time() . '_' . basename($_FILES['novas_imagens']['name'][$key]);
                $caminho_imagem = 'images/' . $nome_imagem;
                move_uploaded_file($tmp_name, $caminho_imagem);
                $imagens_novas[] = $nome_imagem;
            }
            // Atualiza a lista de imagens apenas com as novas imagens
            $imagens = $imagens_novas;
        }

        // Atualiza os dados do produto no banco de dados
        $imagens_str = implode(",", $imagens);
        $query_update = "UPDATE produtos SET nome='$nome', preco='$preco', descricao='$descricao', imagens='$imagens_str' WHERE id=$produto_id";
        $result_update = mysqli_query($conexao, $query_update);

        // Verifica se houve sucesso na atualização
       
    }
    ?>
    <form method="post" enctype="multipart/form-data">
        <?php if ($result_update) {
            echo "Produto atualizado com sucesso.";
            // Atualiza a página após 1 segundo
            header("refresh:1; url=index.php");
        
        }?>
        <div class="form-group">
            <label for="nome">Name:</label>
            <input type="text" name="nome" id="nome" value="<?php echo $nome; ?>" required>
        </div>
        <div class="form-group">
            <label for="preco">Price:</label>
            <input type="text" name="preco" id="preco" value="<?php echo $preco; ?>" required>
        </div>
        <div class="form-group">
            <label for="descricao">Description:</label>
            <div id="descricao-container">
                <textarea id="descricao" name="descricao" required><?php echo $descricao; ?></textarea>
                
        <div class="form-group">
            <label for="novas_imagens">New Images:</label>
            <input type="file" name="novas_imagens[]" id="novas_imagens" multiple>
        </div>
        <div class="form-group">
            <label>Current Images:</label>
            <?php foreach ($imagens as $imagem) { ?>
                <img src="images/<?php echo $imagem; ?>" alt="<?php echo $imagem; ?>" class="preview">
            <?php } ?>
        </div>
        <input type="submit" value="Update App">
    </form>
</div>

<?php include('includes/footer.php'); ?>

<script>
    function toggleEditor() {
        var editorContainer = document.querySelector('.editor-container');
        var textarea = document.getElementById('descricao');
        
        if (editorContainer.style.display === "none") {
            // Se a área de edição estiver oculta, exibe-a e oculta a área de texto simples
            editorContainer.style.display = "block";
            textarea.style.display = "none";
        } else {
            // Se a área de edição estiver visível, oculta-a e exibe a área de texto simples
            editorContainer.style.display = "none";
            textarea.style.display = "block";
        }
    }
</script>

</body>
</html>
