<?php
// Inclua o arquivo de conexão com o banco de dados e outras dependências
require_once('includes/database.php');
include('includes/header.php');

// Consulta para selecionar todos os produtos
$query = "SELECT * FROM produtos";
$result = mysqli_query($conexao, $query);
?>

<!DOCTYPE html>
<html lang="es-MX">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MODELOS APKS</title>
    <link rel="stylesheet" href="css/carousel.css"> <!-- Estilos específicos para o carrossel -->
</head>
<style>
.banner {
    max-height: 400px; /* Defina a altura máxima desejada */
    width: auto; /* Isso garantirá que a largura seja ajustada automaticamente para manter a proporção da imagem */
    margin: 0 auto; /* Centralizar o banner na página */
    display: block; /* Garante que o banner seja exibido como um bloco */
}

</style>
<body>



<div class="carousel banner-carousel">
    <!-- Aqui vão as imagens dos banners em um carrossel -->
    <?php include 'admin/banners.php'; ?>
    <?php foreach ($banners as $banner) : ?>
        <img src="<?php echo $banner['image']; ?>" alt="<?php echo $banner['title']; ?>">
    <?php endforeach; ?>
    <!-- Botões de navegação -->
    <a class="prev" onclick="plusSlides(-1)">&#10094;</a>
    <a class="next" onclick="plusSlides(1)">&#10095;</a>
</div>

<script>
    var slideIndex = 0;
    showSlides();

    function showSlides() {
        var i;
        var slides = document.querySelectorAll('.banner-carousel img');
        for (i = 0; i < slides.length; i++) {
            slides[i].style.display = "none";  
        }
        slideIndex++;
        if (slideIndex > slides.length) {slideIndex = 1}    
        slides[slideIndex-1].style.display = "block";  
        setTimeout(showSlides, 3000); // Muda a imagem a cada 3 segundos (3000 milissegundos)
    }
</script>
<header>
    <h1>MODELOS APKS</h1>
</header>
<div class="container">
    <div class="produtos">
        <?php while ($row = mysqli_fetch_assoc($result)) { ?>
            <div class="produto" onmouseover="startProductCarousel(this)" onmouseout="stopProductCarousel(this)">
                <div class="carousel">
                    <?php
                    // Verifica se há imagens para exibir
                    if (!empty($row['imagens'])) {
                        $imagens = explode(",", $row['imagens']);
                        // Exibe cada imagem do produto como um slide do carrossel
                        foreach ($imagens as $imagem) {
                            echo '<img class="slide" src="admin/images/' . $imagem . '" alt="' . $row['nome'] . '">';
                        }
                    } else {
                        echo "Nenhuma imagem disponível";
                    }
                    ?>
                </div>
                <h3><?php echo $row['nome']; ?></h3>
                <a href="produto.php?id=<?php echo $row['id']; ?>" class="btn-ver-mais">Detalles del APK</a>
            </div> <!-- Fim da div .produto -->
        <?php } ?>
    </div> <!-- Fim da div .produtos -->
</div> <!-- Fim da div .container -->

<?php include('includes/footer.php'); ?>

<script src="js/carousel.js"></script>

<script>
    let productInterval;

    function startProductCarousel(product) {
        const slides = product.querySelectorAll('.slide');
        let index = 0;
        productInterval = setInterval(() => {
            slides[index].style.display = "none";
            index = (index + 1) % slides.length;
            slides[index].style.display = "block";
        }, 3000);
    }

    function stopProductCarousel() {
        clearInterval(productInterval);
    }
</script>

</body>
</html>
